#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "map.h"
#include "linkstuff.h"

extern int My_host_id;
extern unsigned char My_mac_addr[];
extern char *Test_x1;
extern int Test_p1;
extern char *Test_x2;
extern int Test_p2;
extern int Test_id_pkts;
extern int Hport;

int Ntests;
int Nretries;

int test_this_route(unsigned char *route, int rlen, int report);
int do_this_xbar(struct xbar *xp, int in_port, unsigned char *route,
	         int rlen, int depth);


int
do_this_xbar(
  struct xbar *xp,
  int in_port,
  unsigned char *route,
  int rlen,
  int depth)
{
  int total_rlen;
  int i;
  struct xbar *newxp;
  int new_port;
  int count;

  /* printf("doing xbar %s, in_port: %d, depth: %d\n", xp->name, in_port, depth); */

  /* if depth is zero, this is a leaf, execute the tests */
  if (depth == 0) {
    
    /* U-turn byte. If using xbar32 ID packets, use 0xA0, for raw data packets,
     * use a 0 to redirect the packet back to where it came from
     */
    route[rlen] = (Test_id_pkts) ? 0xA0 : DELTA_TO_ROUTE(0);

    /* then build path back to origin */
    for (i=0; i<rlen; ++i) {
      route[rlen+i+1] = DELTA_TO_ROUTE(-ROUTE_TO_DELTA(route[rlen-i-1]));
    }
    total_rlen = 2 * rlen + 1;

    if ((Test_x1 == NULL) ||
	(Test_p1 == in_port && Test_p2 == xp->port[in_port].conn_port &&
	 strcmp(Test_x1, xp->name) == 0 &&
	 strcmp(Test_x2, xp->port[in_port].ptr.x->name) == 0) ||
	(Test_p2 == in_port && Test_p1 == xp->port[in_port].conn_port &&
	 strcmp(Test_x2, xp->name) == 0 &&
	 strcmp(Test_x1, xp->port[in_port].ptr.x->name) == 0)) {

      /* perform the test, report if fails */
      ++Ntests;	/* keep track of links tested */

      if (test_this_route(route, total_rlen, 1) == 0) {

	/* mark both ends bad */
	xp->port[in_port].bad = 1;
	xp->port[in_port].ptr.x->port[(int)(xp->port[in_port].conn_port)].bad = 1;

	/* ID the link */
	printf("%s:%d <-> %s:%d failed test.\n\n",
	  xp->name, in_port,
	  xp->port[in_port].ptr.x->name, xp->port[in_port].conn_port);
      }
    }

    return 1;


  /* non-zero depth means to branch out to next level of non-tested xbars */
  } else {

    count = 0;		/* count how many new ports we tested */

    /* Now, work on each attached xbar */
    for (i=0; i<xp->nport; ++i) {

      /* skip non-xbars and bad ports */
      if (xp->port[i].conn_type != CONN_XBAR ||
	  xp->port[i].bad) {
	continue;
      }

      /* xbar and port we will process next */
      newxp = xp->port[i].ptr.x;
      new_port = xp->port[i].conn_port;

      /* route to the new xbar */
      route[rlen] = DELTA_TO_ROUTE(i - in_port);

      /* depth of 1 means the links will be tested */
      if (depth == 1) {

	/* If this port already tested, continue */
	if (xp->port[i].tested) {
	  continue;
	}

	xp->port[i].tested = 1;	/* this link has been tested */
	newxp->port[new_port].tested = 1;
      }

      /* process the xbar */
      count += do_this_xbar(newxp, new_port, route, rlen+1, depth-1);
    }
  }

  /* return the number of tests performed */
  return count;
}

void
check_all_links(struct mapfile *mp)
{
  struct host *h;
  struct hostport *hp;
  struct xbar *xb;
  unsigned char route[32];
  int port;
  int depth;
  int rc = 1;

  /* This is the host we start from */
  h = mp->host + My_host_id;
  hp = &(h->port[Hport]);
  xb = hp->xbar;
  port = hp->xbport;

  /* keep running the checker at increasing depths until nothing found */
  Ntests = 0;
  Nretries = 0;
  depth = 0;
  while (rc) {
    rc = do_this_xbar(xb, port, route, 0, depth);
    ++depth;
  }

  printf ("%d links checked, %d retries.\n", Ntests, Nretries);
}
